<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DynamicForm extends Model 
{

    protected $table = 'dynamic_forms';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_ar', 'name_en', 'description_ar', 'description_en', 'will_be_signed', 'signature_invitation_data', 'status');

    public function fields()
    {
        return $this->hasMany('App\Models\DynamicFormField');
    }

}